﻿using AutoMapper;
using QualityManagement.Data.Dto;
using QualityManagement.Helper;
using QualityManagement.Repository;
using MediatR;
using Microsoft.EntityFrameworkCore;
using System.Collections.Generic;
using System.Linq;
using System.Threading;
using System.Threading.Tasks;

namespace QualityManagement.MediatR
{
    public class GetAllClientQueryHandler(IClientRepository _clientRepository, IMapper _mapper) : IRequestHandler<GetAllClientQuery, ServiceResponse<List<ClientDto>>>
    {
        public async Task<ServiceResponse<List<ClientDto>>> Handle(GetAllClientQuery request, CancellationToken cancellationToken)
        {
            var entities = await _clientRepository.All
                .OrderByDescending(c => c.CreatedDate)
                .ToListAsync(cancellationToken);
            if (entities.Count == 0)
            {
                return ServiceResponse<List<ClientDto>>.ReturnResultWith200([]);
            }
            var entityDtos = _mapper.Map<List<ClientDto>>(entities);
            return ServiceResponse<List<ClientDto>>.ReturnResultWith200(entityDtos);
        }
    }
}