﻿using MediatR;
using QualityManagement.Data;
using QualityManagement.Data.Dto;
using QualityManagement.Data.Entities;
using QualityManagement.Helper;
using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations.Schema;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace QualityManagement.MediatR
{
    public class AddComplaintCommand : IRequest<ServiceResponse<ComplaintDto>>
    {
        public  string Title { get; set; }
        public  string Description { get; set; }
        public DateTime ComplaintDate { get; set; }
        public ReportedByEnum ReportedBy { get; set; }
        public  Guid AssignedToId { get; set; }
        public Guid ComplaintTypeId { get; set; }
        public ComplaintPriorityEnum Priority { get; set; }
        public ComplaintStatusEnum Status { get; set; }
        public string ResolutionSummary { get; set; }
    }
}
