﻿using Amazon.Runtime.Internal.Util;
using AutoMapper;
using MediatR;
using Microsoft.EntityFrameworkCore;
using Microsoft.Extensions.Logging;
using QualityManagement.Data.Dto;
using QualityManagement.Helper;
using QualityManagement.Repository;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading;
using System.Threading.Tasks;

namespace QualityManagement.MediatR
{
    public class GetAllAsignComplaintCommandHandler(
        IComplaintRepository _complaintRepository,
        UserInfoToken _userInfoToken,
        IMapper _mapper,
        ILogger<GetAllAsignComplaintCommandHandler> logger) : IRequestHandler<GetAllAsignComplaintCommand, ServiceResponse<List<ComplaintDto>>>
    {
        public async Task<ServiceResponse<List<ComplaintDto>>> Handle(GetAllAsignComplaintCommand request, CancellationToken cancellationToken)
        {
            try
            {
                var userId = _userInfoToken.Id;
                var complaints = await _complaintRepository.All
                .Where(c => c.AssignedToId == userId ||
                        c.ComplaintActions.Any(c=>c.ResponsibleId == userId) ||  
                        c.ComplaintInvestigations.Any(c=>c.InvestigatorId ==userId))
                    .Include(c => c.ComplaintType)
                    .Include(c => c.ComplaintActions.Where(c => c.ResponsibleId == _userInfoToken.Id))
                    .ThenInclude(c => c.Responsible)
                    .Include(c =>c.ComplaintInvestigations.Where(c => c.InvestigatorId == userId)).ThenInclude(c=>c.Investigator)
                .Include(c => c.AssignedTo).ToListAsync();

                var dto = _mapper.Map<List<ComplaintDto>>(complaints);
                return ServiceResponse<List<ComplaintDto>>.ReturnResultWith200(dto);
            }
            catch (Exception ex)
            {
                logger.LogError(ex, "error while getting GetallAsign Complaint");
                return ServiceResponse<List<ComplaintDto>>.Return500("error while getting GetallAsign Complaint");

            }

        }
    }
}
