﻿using AutoMapper;
using MediatR;
using Microsoft.EntityFrameworkCore;
using Microsoft.Extensions.Logging;
using QualityManagement.Data.Dto;
using QualityManagement.Data.Dto.RiskManagement;
using QualityManagement.Helper;
using QualityManagement.Repository;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading;
using System.Threading.Tasks;

namespace QualityManagement.MediatR
{
    public class GetComplaintCommandHandler (
        IComplaintRepository _complaintRepository,
        IMapper _mapper,
        ILogger<GetComplaintCommandHandler> _logger): IRequestHandler<GetComplaintCommand, ServiceResponse<ComplaintDto>>
    {
        public async Task<ServiceResponse<ComplaintDto>> Handle(GetComplaintCommand request, CancellationToken cancellationToken)
        {
            try
            {
                var entity = await _complaintRepository
                .All
                .Where(c => c.Id == request.Id).FirstOrDefaultAsync();
                if (entity == null)
                {
                    return ServiceResponse<ComplaintDto>.Return404(" Complaint not found");
                }
                var entityDto = _mapper.Map<ComplaintDto>(entity);
                return ServiceResponse<ComplaintDto>.ReturnResultWith201(entityDto);
            }
            catch (System.Exception ex)
            {
                _logger.LogError(ex, "Error while getting Complaint");
                return ServiceResponse<ComplaintDto>.Return500("Error while getting Complaint");
            }

        }
    }
}
