﻿using MediatR;
using QualityManagement.Repository;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading;
using System.Threading.Tasks;

namespace QualityManagement.MediatR
{
    public class GetComplaintListCommandHandler(
        IComplaintRepository _complaintRepository) : IRequestHandler<GetComplaintListCommand, ComplaintList>
    {
        public async Task<ComplaintList> Handle(GetComplaintListCommand request, CancellationToken cancellationToken)
        {
            return await _complaintRepository.GetComplaint(request.ComplaintResource);
        }
    }
}
