﻿using MediatR;
using QualityManagement.Data.Dto;
using QualityManagement.Data.Entities;
using QualityManagement.Helper;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace QualityManagement.MediatR
{
    public class UpdateComplaintCommand:IRequest<ServiceResponse<ComplaintDto>>
    {
        public Guid Id { get; set; }
        public string Title { get; set; }
        public string Description { get; set; }
        public ReportedByEnum ReportedBy { get; set; }
        public Guid AssignedToId { get; set; }
        public Guid ComplaintTypeId { get; set; }
        public ComplaintPriorityEnum Priority { get; set; } 
        public ComplaintStatusEnum Status { get; set; }
        public string ResolutionSummary { get; set; }
        public DateTime ComplaintDate { get; set; }
    }
}
