﻿using MediatR;
using QualityManagement.Data.Dto;
using QualityManagement.Data.Entities;
using QualityManagement.Helper;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace QualityManagement.MediatR
{
    public class AddComplaintActionCommand:IRequest<ServiceResponse<ComplaintActionDto>>
    {
        public Guid ComplaintId { get; set; }
        public string ActionTitle { get; set; }
        public string ActionDetail { get; set; }
        public Guid ResponsibleId { get; set; }
        public ComplaintStatusEnum Status { get; set; } // e.g., "Pending", "Completed", "In Progress"
        public DateTime? DueDate { get; set; } // Optional due date for the action
        public DateTime? CompletedDate { get; set; }
    }
}
