﻿using FluentValidation;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace QualityManagement.MediatR
{
    public class AddComplaintActionCommandValidator:AbstractValidator<AddComplaintActionCommand>
    {
        public AddComplaintActionCommandValidator()
        {
            RuleFor(c => c.ComplaintId).Must(c => c.GuidNotEmpty()).WithMessage("Complaint id is required");
            RuleFor(c => c.ResponsibleId).Must(c => c.GuidNotEmpty()).WithMessage("Responsible id is required");
            RuleFor(c => c.ActionTitle).NotEmpty().WithMessage("comment text is required");
        }
    }
    
}
