﻿using AutoMapper;
using MediatR;
using Microsoft.Extensions.Logging;
using QualityManagement.Common.UnitOfWork;
using QualityManagement.Data.Dto;
using QualityManagement.Data.Entities;
using QualityManagement.Domain;
using QualityManagement.Helper;
using QualityManagement.Repository;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading;
using System.Threading.Tasks;

namespace QualityManagement.MediatR
{
    public class AddComplaintAttachmentCommandHandler(

        IComplaintRepository  _complaintRepository,
        IComplaintAttchmentRepository _complaintAttchmentRepository,
        IMapper _mapper,
        IUnitOfWork<QMSDbContext> _uow,
        ILogger<AddComplaintAttachmentCommandHandler> _logger,
        UserInfoToken userInfoToken,
        IStorageSettingRepository _storageSettingRepository) : IRequestHandler<AddComplaintAttachmentCommand, ServiceResponse<ComplaintAttachmentDto>>
    {
        public async Task<ServiceResponse<ComplaintAttachmentDto>> Handle(AddComplaintAttachmentCommand request, CancellationToken cancellationToken)
        {
            try
            {
                var existComplaint = await _complaintRepository.FindAsync(request.ComplaintId);
                if (existComplaint == null)
                {
                    return ServiceResponse<ComplaintAttachmentDto>.Return404("Complaint not found");
                }
                var storeageSetting = await _storageSettingRepository.GetStorageSettingByIdOrLocal(null);
                var keyValut = KeyGenerator.GenerateKeyAndIV();
                var entity = _mapper.Map<ComplaintAttachment>(request);
                entity.Key = storeageSetting.EnableEncryption ? keyValut.Item1 : null;
                entity.IV = storeageSetting.EnableEncryption ? keyValut.Item2 : null;
                entity.StorageSettingId = storeageSetting.Id;
                entity.UploadedById = userInfoToken.Id;
                entity.UploadedDate = DateTime.UtcNow;

                _complaintAttchmentRepository.Add(entity);

                if (await _uow.SaveAsync(cancellationToken) < 0)
                {
                    return ServiceResponse<ComplaintAttachmentDto>.Return500();
                }
                var entityDto = _mapper.Map<ComplaintAttachmentDto>(entity);
                return ServiceResponse<ComplaintAttachmentDto>.ReturnResultWith201(entityDto);
            }
            catch (System.Exception ex)
            {
                _logger.LogError(ex, "Error while saving ComplaintAttachment");
                return ServiceResponse<ComplaintAttachmentDto>.Return500("Error while saving ComplaintAttachment");
            }
        }
    }
}
