﻿using Amazon.Runtime.Internal.Util;
using AutoMapper;
using MediatR;
using Microsoft.EntityFrameworkCore;
using Microsoft.Extensions.Logging;
using QualityManagement.Data.Dto;
using QualityManagement.Helper;
using QualityManagement.Repository;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading;
using System.Threading.Tasks;

namespace QualityManagement.MediatR
{
    public class GetAllComplaintCommentCommandHandle(
        IComplaintCommentRepository _complaintCommentRepository,
        IMapper _mapper,
        ILogger<GetAllComplaintCommentCommandHandle> _logger) : IRequestHandler<GetAllComplaintCommentCommand, ServiceResponse<List<ComplaintCommentDto>>>
    {
        public async Task<ServiceResponse<List<ComplaintCommentDto>>> Handle(GetAllComplaintCommentCommand request, CancellationToken cancellationToken)
        {

            try
            {
                var entities = await _complaintCommentRepository.All.Include(c=>c.CommentedBy)
                 .Where(c => c.ComplaintId == request.ComplaintId).ToListAsync();
                var entitiesDto = _mapper.Map<List<ComplaintCommentDto>>(entities);
                return ServiceResponse<List<ComplaintCommentDto>>.ReturnResultWith200(entitiesDto);
            }
            catch (System.Exception ex) 
            {
                _logger.LogError(ex, "Error while getting ComplaintComment.");
                return ServiceResponse<List<ComplaintCommentDto>>.Return500("Error while getting ComplaintComment.");
            }

        }
    }
}
