﻿using FluentValidation;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace QualityManagement.MediatR
{
    public class AddComplaintInvestigationCommandValidator:AbstractValidator<AddComplaintInvestigationCommand>
    {
        public AddComplaintInvestigationCommandValidator()
        {
            RuleFor(c => c.ComplaintId).Must(c => c.GuidNotEmpty()).WithMessage("Complaint id is required");
            RuleFor(c => c.InvestigatorId).Must(c => c.GuidNotEmpty()).WithMessage("InvestigatorId id is required");
            RuleFor(c => c.Findings).NotEmpty().WithMessage("Findings text is required");
          //  RuleFor(c => c.Recommendations).NotEmpty().WithMessage("Findings text is required");
        }
    }
    
}
