﻿using MediatR;
using Microsoft.EntityFrameworkCore;
using Microsoft.Extensions.Logging;
using QualityManagement.Common.UnitOfWork;
using QualityManagement.Domain;
using QualityManagement.Helper;
using QualityManagement.Repository;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading;
using System.Threading.Tasks;

namespace QualityManagement.MediatR
{
    public class DeleteComplaintInvestigationCommandHandler (
        IComplaintInvestigationRepository _complaintInvestigationRepository,
        IUnitOfWork<QMSDbContext> _uow,
        ILogger<DeleteComplaintInvestigationCommandHandler> _logger): IRequestHandler<DeleteComplaintInvestigationCommand, ServiceResponse<bool>>
    {
        public async Task<ServiceResponse<bool>> Handle(DeleteComplaintInvestigationCommand request, CancellationToken cancellationToken)
        {
            try
            {
                var entityExit = await _complaintInvestigationRepository.All
                   .FirstOrDefaultAsync(c => c.Id == request.Id);
                if (entityExit == null)
                {
                    return ServiceResponse<bool>.Return404();
                }
                _complaintInvestigationRepository.Remove(entityExit);
                if (await _uow.SaveAsync(cancellationToken) < 0)
                {
                    return ServiceResponse<bool>.Return500();
                }
                return ServiceResponse<bool>.ReturnResultWith200(true);
            }
            catch (System.Exception ex)
            {
                _logger.LogError(ex, "Error while deleting ComplaintInvestigation");
                return ServiceResponse<bool>.Return500("Error while deleting ComplaintInvestigation");
            }
        }
    }
}
