﻿using Amazon.Runtime.Internal.Util;
using AutoMapper;
using MediatR;
using Microsoft.EntityFrameworkCore;
using Microsoft.Extensions.Logging;
using QualityManagement.Common.UnitOfWork;
using QualityManagement.Data.Dto;
using QualityManagement.Domain;
using QualityManagement.Helper;
using QualityManagement.Repository;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading;
using System.Threading.Tasks;

namespace QualityManagement.MediatR
{
    public class UpdateComplaintInvestigationCommandHandler(
        IComplaintInvestigationRepository _complaintInvestigationRepository,
        IUnitOfWork<QMSDbContext> _uow,
        ILogger<UpdateComplaintInvestigationCommandHandler> _logger,
        IMapper _mapper,
        IUserRepository _userRepository) : IRequestHandler<UpdateComplaintInvestigationCommand, ServiceResponse<ComplaintInvestigationDto>>
    {
        public async Task<ServiceResponse<ComplaintInvestigationDto>> Handle(UpdateComplaintInvestigationCommand request, CancellationToken cancellationToken)
        {
            try
            {
                var entityExist = await _complaintInvestigationRepository.All.Where(c => c.Id == request.Id).FirstOrDefaultAsync();
                if (entityExist == null)
                {
                    return ServiceResponse<ComplaintInvestigationDto>.Return404("Complaint Investigation not found");
                }
                _mapper.Map(request, entityExist);
                _complaintInvestigationRepository.Update(entityExist);
                if (await _uow.SaveAsync() <= 0)
                {
                    return ServiceResponse<ComplaintInvestigationDto>.Return500();
                }
                var user = await _userRepository.All.Where(c => c.Id == entityExist.InvestigatorId).FirstOrDefaultAsync();
                if (user != null)
                {
                    entityExist.Investigator = user;
                }
                var dto = _mapper.Map<ComplaintInvestigationDto>(entityExist);

                return ServiceResponse<ComplaintInvestigationDto>.ReturnResultWith200(dto);
            }
            catch (System.Exception ex)
            {
                _logger.LogError(ex, "error while updating Invetigation");
                return ServiceResponse<ComplaintInvestigationDto>.Return500("error while updating Invetigation");
            }

        }
    }
}
