﻿using AutoMapper;
using MediatR;
using Microsoft.EntityFrameworkCore;
using Microsoft.Extensions.Logging;
using QualityManagement.Common.UnitOfWork;
using QualityManagement.Data.Dto;
using QualityManagement.Data.Entities;
using QualityManagement.Domain;
using QualityManagement.Helper;
using QualityManagement.Repository;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading;
using System.Threading.Tasks;

namespace QualityManagement.MediatR
{
    public class AddComplaintRootCauseCommandHandler 
        (
       
        IComplaintRootCauseRepository _complaintRootCauseRepository,
        IMapper _mapper,
        IUserRepository _userRepository,
        IUnitOfWork<QMSDbContext> _uow,
        ILogger<AddComplaintCommentCommandHandler> _logger,
        UserInfoToken _userInfoToken) : IRequestHandler<AddComplaintRootCauseCommand, ServiceResponse<ComplaintRootCauseDto>>
    {
        public async Task<ServiceResponse<ComplaintRootCauseDto>> Handle(AddComplaintRootCauseCommand request, CancellationToken cancellationToken)
        {
            try
            {

                var entity = _mapper.Map<ComplaintRootCause>(request);
                entity.CreatedById = _userInfoToken.Id;
                entity.CreatedAt = DateTime.UtcNow;

                _complaintRootCauseRepository.Add(entity);
                if (await _uow.SaveAsync(cancellationToken) < 0)
                {
                    return ServiceResponse<ComplaintRootCauseDto>.Return500();
                }
                var user = await _userRepository.All.Where(c => c.Id == entity.CreatedById).FirstOrDefaultAsync();
                if (user != null)
                {
                    entity.CreatedBy = user;
                }
                var entityDto = _mapper.Map<ComplaintRootCauseDto>(entity);
                return ServiceResponse<ComplaintRootCauseDto>.ReturnResultWith201(entityDto);
            }
            catch (Exception ex) 
            {
                _logger.LogError(ex,"Error while savingComplaintRoot Cuase");
                return ServiceResponse<ComplaintRootCauseDto>.Return500("Error while savingComplaintRoot Cuase");
            }


        }
    }
}
