﻿using System.Linq;
using System.Threading;
using System.Threading.Tasks;
using AutoMapper;
using MediatR;
using Microsoft.EntityFrameworkCore;
using Microsoft.Extensions.Logging;
using QualityManagement.Common.UnitOfWork;
using QualityManagement.Data.Dto;
using QualityManagement.Data.Entities;
using QualityManagement.Domain;
using QualityManagement.Helper;
using QualityManagement.Repository;

namespace QualityManagement.MediatR;

public class AddComplaintTypeCommandHandler(

    IComplaintTypeRepository _complaintTypeRepository,
    IMapper _mapper,
    IUnitOfWork<QMSDbContext> _uow,
    ILogger<AddComplaintTypeCommandHandler> logger) : IRequestHandler<AddComplaintTypeCommand, ServiceResponse<ComplaintTypeDto>>
{
    public async Task<ServiceResponse<ComplaintTypeDto>> Handle(AddComplaintTypeCommand request, CancellationToken cancellationToken)
    {

        try
        {
            var existingEntity = await _complaintTypeRepository.All
                .Where(s => s.Name.ToLower() == request.Name.ToLower()).FirstOrDefaultAsync();
            if (existingEntity != null)
            {
                return ServiceResponse<ComplaintTypeDto>.Return409("ComplaintType name is already exist");
            }
            var entity = _mapper.Map<ComplaintType>(request);
            _complaintTypeRepository.Add(entity);
            if (await _uow.SaveAsync(cancellationToken) < 0)
            {
                return ServiceResponse<ComplaintTypeDto>.Return500();
            }
            var entityDto = _mapper.Map<ComplaintTypeDto>(entity);
            return ServiceResponse<ComplaintTypeDto>.ReturnResultWith201(entityDto);
        }
        catch (System.Exception ex)
        {
            logger.LogError(ex, "Error while saving ComplaintType");
            return ServiceResponse<ComplaintTypeDto>.Return500("Error while saving ComplaintType");
        }
    }
}
