﻿
using System.Threading;
using System.Threading.Tasks;
using AutoMapper;
using MediatR;
using Microsoft.Extensions.Logging;
using QualityManagement.Data.Dto;
using QualityManagement.Helper;
using QualityManagement.Repository;

namespace QualityManagement.MediatR;

public class GetComplaintTypeCommandHandler(
    IComplaintTypeRepository _complaintTypeRepository,
    IMapper _mapper,
    ILogger<GetComplaintTypeCommandHandler> _logger) : IRequestHandler<GetComplaintTypeCommand, ServiceResponse<ComplaintTypeDto>>
{
    public async Task<ServiceResponse<ComplaintTypeDto>> Handle(GetComplaintTypeCommand request, CancellationToken cancellationToken)
    {
        try
        {
            var entity = await _complaintTypeRepository.FindAsync(request.Id);
            if (entity == null)
            {
                return ServiceResponse<ComplaintTypeDto>.Return404("Not Found");
            }
            var entityDto = _mapper.Map<ComplaintTypeDto>(entity);
            return ServiceResponse<ComplaintTypeDto>.ReturnResultWith200(entityDto);
        }
        catch (System.Exception ex)
        {
            _logger.LogError(ex, " Error while Get ComplaintType");
            return ServiceResponse<ComplaintTypeDto>.Return500();
        }
    }
}
