﻿namespace QualityManagement.MediatR;

public class ContentExtractorFactory
{
    public static IContentExtractor GetExtractor(string fileExtension, string wwwRootPath)
    {
        return fileExtension.ToLower() switch
        {
            ".pdf" => new PdfContentExtractor(wwwRootPath),
            ".doc" or ".docx" => new WordContentExtractor(),
            ".xls" or ".xlsx" => new ExcelContentExtractor(),
            ".ppt" or ".pptx" => new PptContentExtractor(),
            ".txt" => new TextContentExtractor(),
            _ => null
        };
    }
}
