﻿using AutoMapper;
using QualityManagement.Common.UnitOfWork;
using QualityManagement.Data;
using QualityManagement.Data.Dto;
using QualityManagement.Domain;
using QualityManagement.Helper;
using QualityManagement.MediatR;
using QualityManagement.Repository;
using MediatR;
using Microsoft.Extensions.Logging;
using System;
using System.Threading;
using System.Threading.Tasks;

namespace QualityManagement.MediatR;
public class AddSessionMediaChunkCommandHandler(
    ICourseSessionMediaRepository sessionMediaRepository,
    IUnitOfWork<QMSDbContext> _uow,
    IMapper _mapper,
    StorageServiceFactory _storeageServiceFactory,
    IStorageSettingRepository _storageSettingRepository,
    ILogger<AddSessionMediaChunkCommandHandler> logger) : IRequestHandler<AddSessionMediaChunkCommand, ServiceResponse<CourseSessionMediaDto>>
{
    public async Task<ServiceResponse<CourseSessionMediaDto>> Handle(AddSessionMediaChunkCommand request, CancellationToken cancellationToken)
    {
        try
        {
            var storeageSetting = await _storageSettingRepository.GetStorageSettingByIdOrLocal(request.StorageSettingId);
            var storageService = _storeageServiceFactory.GetStorageService(storeageSetting.StorageType);
            var keyValut = KeyGenerator.GenerateKeyAndIV();
            var entity = _mapper.Map<CourseSessionMedia>(request);
            entity.Key = storeageSetting.EnableEncryption ? keyValut.Item1 : null;
            entity.IV = storeageSetting.EnableEncryption ? keyValut.Item2 : null;
            entity.StorageType = storeageSetting.StorageType;
            entity.StorageSettingId = storeageSetting.Id;
            entity.IsChunk = true;
            entity.IsAllChunkUploaded = false;
            entity.Extension = request.Extension;
            var extension = request.Extension;
            if (!extension.StartsWith("."))
                extension = "." + extension;
            entity.Url = Guid.NewGuid() + extension;

            sessionMediaRepository.Add(entity);

            if (await _uow.SaveAsync() <= 0)
            {
                return ServiceResponse<CourseSessionMediaDto>.ReturnFailed(500, "Error while saving media");
            }

            var entityDto = _mapper.Map<CourseSessionMediaDto>(entity);
            return ServiceResponse<CourseSessionMediaDto>.ReturnResultWith200(entityDto);
        }
        catch (Exception ex)
        {
            logger.LogError(ex, "Error while saving media");
            return ServiceResponse<CourseSessionMediaDto>.ReturnFailed(500, "Error while saving media");
        }
    }
}
