﻿using System.Linq;
using System.Threading;
using System.Threading.Tasks;
using QualityManagement.Helper;
using QualityManagement.Repository;
using MediatR;
using Microsoft.EntityFrameworkCore;

namespace QualityManagement.MediatR;
public class CheckMideaStoreAsChunkCommandHandler(
    ICourseSessionMediaRepository courseSessionMediaRepository)
    : IRequestHandler<CheckMideaStoreAsChunkCommand, ServiceResponse<bool>>
{
    public async Task<ServiceResponse<bool>> Handle(CheckMideaStoreAsChunkCommand request, CancellationToken cancellationToken)
    {
        var documentVersion = await courseSessionMediaRepository
            .All
            .Where(c => c.Id == request.SessionMediaId)
            .FirstOrDefaultAsync();

        if (documentVersion == null)
        {

            return ServiceResponse<bool>.ReturnFailed(404, "Document version is not found");
        }

        return ServiceResponse<bool>.ReturnResultWith200(documentVersion.IsChunk);
    }
}
