﻿using System.Collections.Generic;
using System.Linq;
using System.Threading;
using System.Threading.Tasks;
using QualityManagement.Data.Dto;
using QualityManagement.Repository;
using MediatR;
using Microsoft.EntityFrameworkCore;
using Microsoft.Extensions.Logging;

namespace QualityManagement.MediatR;
public class GetSessionMediaCommandHandler(
    ICourseSessionMediaRepository courseSessionMediaRepository,
    ILogger<GetSessionMediaCommandHandler> logger)
    : IRequestHandler<GetSessionMediaCommand, List<CourseSessionMediaDto>>
{
    public async Task<List<CourseSessionMediaDto>> Handle(GetSessionMediaCommand request, CancellationToken cancellationToken)
    {
        try
        {
            var sessionMedia = await courseSessionMediaRepository
                .All
                .Where(c => c.CourseSessionId == request.CourseSessionId)
                .Select(d => new CourseSessionMediaDto
                {
                    Id = d.Id,
                    CourseSessionId = d.CourseSessionId,
                    Url = d.Url,
                    Name = d.Name,
                    Extension = d.Extension,
                    IsChunk = d.IsChunk,
                    MediaType = d.MediaType
                })
                .ToListAsync();
            return sessionMedia;
        }
        catch (System.Exception ex)
        {
            logger.LogError(ex, "Error while getting session media");
            return [];
        }
    }
}
