﻿using System;
using System.Threading;
using System.Threading.Tasks;
using AutoMapper;
using QualityManagement.Common.UnitOfWork;
using QualityManagement.Data;
using QualityManagement.Data.Dto;
using QualityManagement.Domain;
using QualityManagement.Helper;
using QualityManagement.Repository;
using MediatR;
using Microsoft.EntityFrameworkCore;
using Microsoft.Extensions.Logging;

namespace QualityManagement.MediatR;
public class CreateQuizQuestionCommandHandler(
    ICourseSessionQuizRepository courseSessionQuizRepository,
    IMapper mapper,
    ILogger<CreateQuizQuestionCommandHandler> logger,
    IQuizQuestionRepository quizQuestionRepository,
    IUnitOfWork<QMSDbContext> unitOfWork)
    : IRequestHandler<CreateQuizQuestionCommand, ServiceResponse<QuizQuestionDto>>
{
    public async Task<ServiceResponse<QuizQuestionDto>> Handle(CreateQuizQuestionCommand request, CancellationToken cancellationToken)
    {
        try
        {
            var quize = await courseSessionQuizRepository.All
                .FirstOrDefaultAsync(c => c.CourseSessionId == request.CourseSessionId);

            Guid quizeId = Guid.NewGuid();
            if (quize == null)
            {
                courseSessionQuizRepository.Add(new CourseSessionQuiz
                {
                    Id = quizeId,
                    CourseSessionId = request.CourseSessionId,
                    PassingScore = 1,
                });
            }
            else
            {
                quizeId = quize.Id;
            }

            var question = mapper.Map<QuizQuestion>(request);
            question.CourseSessionQuizId = quizeId;
            quizQuestionRepository.Add(question);

            if (await unitOfWork.SaveAsync() < 0)
            {
                logger.LogWarning("Error while saving quiz question");
                return ServiceResponse<QuizQuestionDto>.Return500("Error while saving quiz question");
            }

            var questionDto = mapper.Map<QuizQuestionDto>(question);
            return ServiceResponse<QuizQuestionDto>.ReturnResultWith200(questionDto);
        }
        catch (Exception ex)
        {
            logger.LogError(ex, "Error while creating quiz question");
            return ServiceResponse<QuizQuestionDto>.ReturnException(ex);
        }
    }
}
