﻿using QualityManagement.Common.UnitOfWork;
using QualityManagement.Domain;
using QualityManagement.Helper;
using QualityManagement.Repository;
using MediatR;
using Microsoft.Extensions.Logging;
using System.Threading;
using System.Threading.Tasks;

namespace QualityManagement.MediatR;
public class DeleteQuizQuestionCommandHandler(
    IQuizQuestionRepository quizQuestionRepository,
    IUnitOfWork<QMSDbContext> unitOfWork,
    ILogger<DeleteQuizQuestionCommandHandler> logger)
    : IRequestHandler<DeleteQuizQuestionCommand, ServiceResponse<bool>>
{
    public async Task<ServiceResponse<bool>> Handle(DeleteQuizQuestionCommand request, CancellationToken cancellationToken)
    {
        try
        {
            var question = await quizQuestionRepository.FindAsync(request.Id);
            if (question == null)
            {
                logger.LogWarning("Quiz question not found");
                return ServiceResponse<bool>.Return404("Quiz question not found");
            }

            quizQuestionRepository.Remove(question);
            if (await unitOfWork.SaveAsync(cancellationToken) <= 0)
            {
                logger.LogWarning("Error while deleting quiz question");
                return ServiceResponse<bool>.Return500("Error while deleting quiz question");
            }

            return ServiceResponse<bool>.ReturnResultWith200(true);
        }
        catch (System.Exception ex)
        {
            logger.LogError(ex, "Error while deleting quiz question");
            return ServiceResponse<bool>.Return500("Error while deleting quiz question");
        }
    }
}
