﻿using AutoMapper;
using QualityManagement.Data.Dto;
using QualityManagement.Helper;
using QualityManagement.Repository;
using MediatR;
using Microsoft.EntityFrameworkCore;
using Microsoft.Extensions.Logging;
using System.Linq;
using System.Threading;
using System.Threading.Tasks;

namespace QualityManagement.MediatR;
public class GetCourseSessionQuizCommandHandler(
    ICourseSessionQuizRepository courseSessionQuizRepository,
    IMapper mapper,
    ILogger<GetCourseSessionQuizCommandHandler> logger)
    : IRequestHandler<GetCourseSessionQuizCommand, ServiceResponse<CourseSessionQuizDto>>
{
    public async Task<ServiceResponse<CourseSessionQuizDto>> Handle(GetCourseSessionQuizCommand request, CancellationToken cancellationToken)
    {
        try
        {
            var quize = await courseSessionQuizRepository
                .All
                .Include(c => c.QuizQuestions)
                    .ThenInclude(d => d.QuizQuestionOptions)
                .Where(c => c.CourseSessionId == request.CourseSessionId)
                .FirstOrDefaultAsync();

            if (quize == null)
            {
                logger.LogWarning("Course session quiz not found");
                return ServiceResponse<CourseSessionQuizDto>.ReturnSuccess();
            }

            var quizeDto = mapper.Map<CourseSessionQuizDto>(quize);
            quizeDto.QuizQuestions = quizeDto.QuizQuestions.OrderBy(c => c.OrderNo).ToList();
            return ServiceResponse<CourseSessionQuizDto>.ReturnResultWith200(quizeDto);
        }
        catch (System.Exception ex)
        {
            logger.LogError(ex, "Error while getting course session quiz");
            return ServiceResponse<CourseSessionQuizDto>.ReturnException(ex);
        }
    }
}
