﻿using QualityManagement.Common.UnitOfWork;
using QualityManagement.Domain;
using QualityManagement.Helper;
using QualityManagement.Repository;
using MediatR;
using Microsoft.Extensions.Logging;
using System.Threading;
using System.Threading.Tasks;

namespace QualityManagement.MediatR;
public class DeleteCourseSessionCommandHandler(
    ICourseSessionRepository courseSessionRepository,
    IUnitOfWork<QMSDbContext> unitOfWork,
    ILogger<DeleteCourseSessionCommandHandler> logger)
    : IRequestHandler<DeleteCourseSessionCommand, ServiceResponse<bool>>
{
    public async Task<ServiceResponse<bool>> Handle(DeleteCourseSessionCommand request, CancellationToken cancellationToken)
    {
        try
        {
            var courseSession = await courseSessionRepository.FindAsync(request.Id);
            if (courseSession == null)
            {
                return ServiceResponse<bool>.Return404("Course session not found.");
            }

            courseSessionRepository.Delete(courseSession);

            if (await unitOfWork.SaveAsync(cancellationToken) < 0)
            {
                return ServiceResponse<bool>.Return500("Error while deleting course session.");
            }

            return ServiceResponse<bool>.ReturnResultWith200(true);
        }
        catch (System.Exception ex)
        {
            logger.LogError(ex, "Error while deleting course session.");
            return ServiceResponse<bool>.Return500("Error while deleting course session.");
        }
    }
}
