﻿using AutoMapper;
using QualityManagement.Data.Dto;
using QualityManagement.Repository;
using MediatR;
using Microsoft.EntityFrameworkCore;
using System.Collections.Generic;
using System.Linq;
using System.Threading;
using System.Threading.Tasks;

namespace QualityManagement.MediatR;
public class GetCourseSessionByCourseCommandHandler(
    ICourseSessionRepository courseSessionRepository,
    IMapper mapper)
    : IRequestHandler<GetCourseSessionByCourseCommand, List<CourseSessionDto>>
{
    public async Task<List<CourseSessionDto>> Handle(GetCourseSessionByCourseCommand request, CancellationToken cancellationToken)
    {
        var sessions = await courseSessionRepository.All.Where(d => d.CourseId == request.CourseId).ToListAsync();
        return mapper.Map<List<CourseSessionDto>>(sessions);
    }
}
