﻿using AutoMapper;
using QualityManagement.Data.Dto;
using QualityManagement.Helper;
using QualityManagement.Repository;
using MediatR;
using System.Threading;
using System.Threading.Tasks;

namespace QualityManagement.MediatR;
public class GetCourseCommandHandler(
    ICourseRepository courseRepository,
    IMapper mapper)
    : IRequestHandler<GetCourseCommand, ServiceResponse<CourseDto>>
{
    public async Task<ServiceResponse<CourseDto>> Handle(GetCourseCommand request, CancellationToken cancellationToken)
    {
        var course = await courseRepository.FindAsync(request.Id);
        if (course == null)
        {
            return ServiceResponse<CourseDto>.Return404();
        }

        return ServiceResponse<CourseDto>.ReturnResultWith200(mapper.Map<CourseDto>(course));
    }
}
