﻿using QualityManagement.Repository;
using MediatR;
using System.Threading;
using System.Threading.Tasks;

namespace QualityManagement.MediatR;
public class GetCourseListCommandHandler(
    ICourseRepository courseRepository)
    : IRequestHandler<GetCourseListCommand, CourseList>
{
    public async Task<CourseList> Handle(GetCourseListCommand request, CancellationToken cancellationToken)
    {
        return await courseRepository.GetCourses(request.CourseResource);
    }
}
