﻿using QualityManagement.Repository;
using MediatR;
using Microsoft.EntityFrameworkCore;
using System.Linq;
using System.Threading;
using System.Threading.Tasks;

namespace QualityManagement.MediatR
{
    public class GetActiveUserCountQueryHandler(IUserRepository userRepository) : IRequestHandler<GetActiveUserCountQuery, int>
    {
        public async Task<int> Handle(GetActiveUserCountQuery request, CancellationToken cancellationToken)
        {
            return await userRepository.All.Where(c => c.IsActive).CountAsync(cancellationToken);
        }
    }
}
