﻿using AutoMapper;
using MediatR;
using Microsoft.EntityFrameworkCore;
using Microsoft.Extensions.Logging;
using QualityManagement.Data.Dto;
using QualityManagement.Helper;
using QualityManagement.Repository;
using System.Collections.Generic;
using System.Threading;
using System.Threading.Tasks;

namespace QualityManagement.MediatR
{
    public class GetAllDepartmentCommandHandler(IDepartmentRepository _departmentRepository,
        IMapper _mapper,
        ILogger<GetAllDepartmentCommandHandler> _logger) : IRequestHandler<GetAllDepartmentCommand, ServiceResponse<List<DepartmentDto>>>
    {
        public async Task<ServiceResponse<List<DepartmentDto>>> Handle(GetAllDepartmentCommand request, CancellationToken cancellationToken)
        {
            try
            {
                var entities = await _departmentRepository.All.ToListAsync(cancellationToken);
                var entityDto = _mapper.Map<List<DepartmentDto>>(entities);
                return ServiceResponse<List<DepartmentDto>>.ReturnResultWith200(entityDto);
            }
            catch (System.Exception ex)
            {
                _logger.LogError(ex, "Error while Get all Department");
                return ServiceResponse<List<DepartmentDto>>.Return500();
            }

        }
    }
}
