﻿using AutoMapper;
using MediatR;
using Microsoft.Extensions.Logging;
using QualityManagement.Data.Dto;
using QualityManagement.Helper;
using QualityManagement.Repository;
using System.Threading;
using System.Threading.Tasks;

namespace QualityManagement.MediatR
{
    public class GetDepartmentCommandHandler(IDepartmentRepository _departmentRepository,
        IMapper _mapper,
        ILogger<GetDepartmentCommandHandler> _logger) : IRequestHandler<GetDepartmentCommand, ServiceResponse<DepartmentDto>>
    {
        public async Task<ServiceResponse<DepartmentDto>> Handle(GetDepartmentCommand request, CancellationToken cancellationToken)
        {
            try
            {
                var entity = await _departmentRepository.FindAsync(request.Id);
                if (entity == null)
                {
                    return ServiceResponse<DepartmentDto>.Return409("Department Not Found");
                }
                var entities = _mapper.Map<DepartmentDto>(entity);
                return ServiceResponse<DepartmentDto>.ReturnResultWith200(entities);
            }
            catch (System.Exception ex)
            {
                _logger.LogError(ex, "Error while get Department");
                return ServiceResponse<DepartmentDto>.Return500();
            }

        }
    }
}
