﻿using AutoMapper;
using MediatR;
using QualityManagement.Common.UnitOfWork;
using QualityManagement.Data.Dto;
using QualityManagement.Data.Entities;
using QualityManagement.Domain;
using QualityManagement.Repository;
using System;
using System.Collections.Generic;
using System.Threading;
using System.Threading.Tasks;

namespace QualityManagement.MediatR
{
    public class AddDocumentAuditTrailCommandHandler(
        IDocumentAuditTrailRepository _documentAuditTrailRepository,
        IUnitOfWork<QMSDbContext> _uow,
        IMapper _mapper,
        UserInfoToken _userInfo) : IRequestHandler<AddDocumentAuditTrailCommand, DocumentAuditTrailDto>
    {
        public async Task<DocumentAuditTrailDto> Handle(AddDocumentAuditTrailCommand request, CancellationToken cancellationToken)
        {
            var entity = new DocumentAuditTrail();
            entity.DocumentId = request.DocumentId;
            entity.CreatedBy = _userInfo.Id;
            entity.CreatedDate = DateTime.UtcNow;
            entity.OperationName = ParseEnum(request.OperationName);
            _documentAuditTrailRepository.Add(entity);
            if (await _uow.SaveAsync() <= -1)
            {
                var errorDto = new DocumentAuditTrailDto
                {
                    StatusCode = 500,
                    Messages = new List<string> { "An unexpected fault happened. Try again later." }
                };
                return errorDto;
            }
            var entityDto = _mapper.Map<DocumentAuditTrailDto>(entity);
            return entityDto;
        }
        public DocumentOperation ParseEnum(string value)
        {
            return (DocumentOperation)Enum.Parse(typeof(DocumentOperation), value, true);
        }
    }
}
