﻿using MediatR;
using QualityManagement.Repository;
using System.Threading;
using System.Threading.Tasks;

namespace QualityManagement.MediatR
{
    public class GetAllDocumentAuditTrailQueryHandler(
        IDocumentAuditTrailRepository _documentAuditTrailRepository) : IRequestHandler<GetAllDocumentAuditTrailQuery, DocumentAuditTrailList>
    {
        public async Task<DocumentAuditTrailList> Handle(GetAllDocumentAuditTrailQuery request, CancellationToken cancellationToken)
        {
            return await _documentAuditTrailRepository.GetDocumentAuditTrails(request.DocumentResource);
        }
    }
}
