﻿using AutoMapper;
using MediatR;
using Microsoft.Extensions.Logging;
using QualityManagement.Common.UnitOfWork;
using QualityManagement.Data;
using QualityManagement.Data.Dto;
using QualityManagement.Domain;
using QualityManagement.Helper;
using QualityManagement.Repository;
using System.Threading;
using System.Threading.Tasks;

namespace QualityManagement.MediatR;

public class AddDocumentCommentCommandHandler(IDocumentCommentRepository _documentCommentRepository,
IUnitOfWork<QMSDbContext> _uow,
IMapper _mapper,
ILogger<AddDocumentCommentCommandHandler> _logger) : IRequestHandler<AddDocumentCommentCommand, ServiceResponse<DocumentCommentDto>>
{
    public async Task<ServiceResponse<DocumentCommentDto>> Handle(AddDocumentCommentCommand request, CancellationToken cancellationToken)
    {
        var documentCommentEntity = _mapper.Map<DocumentComment>(request);
        _documentCommentRepository.Add(documentCommentEntity);
        if (await _uow.SaveAsync() <= 0)
        {
            _logger.LogError("Error while adding industry");
            return ServiceResponse<DocumentCommentDto>.Return500();
        }
        var documentCommentDto = _mapper.Map<DocumentCommentDto>(documentCommentEntity);
        return ServiceResponse<DocumentCommentDto>.ReturnResultWith200(documentCommentDto);
    }
}

