﻿using MediatR;
using Microsoft.EntityFrameworkCore;
using QualityManagement.Data.Dto;
using QualityManagement.Repository;
using System.Collections.Generic;
using System.Linq;
using System.Threading;
using System.Threading.Tasks;

namespace QualityManagement.MediatR;

public class GetDocumentMetaDataByIdQueryHandler(
    IDocumentMetaDataRepository _documentMetaDataRepository
    ) : IRequestHandler<GetDocumentMetaDataByIdQuery, List<DocumentMetaDataDto>>
{
    public async Task<List<DocumentMetaDataDto>> Handle(GetDocumentMetaDataByIdQuery request, CancellationToken cancellationToken)
    {
        var documentMetaData = await _documentMetaDataRepository.All
            .Include(c => c.DocumentMetaTag)
            .Where(c => c.DocumentId == request.DocumentId)
            .Select(c => new DocumentMetaDataDto
            {
                Id = c.Id,
                Metatag = c.Metatag,
                DocumentId = c.DocumentId,
                DocumentMetaTagId = c.DocumentMetaTagId,
                MetaTagDate = c.MetaTagDate,
                MetaTagType = c.DocumentMetaTag.Type
            })
            .ToListAsync();
        return documentMetaData;
    }
}
