﻿using AutoMapper;
using MediatR;
using Microsoft.EntityFrameworkCore;
using QualityManagement.Common.UnitOfWork;
using QualityManagement.Data;
using QualityManagement.Data.Dto;
using QualityManagement.Domain;
using QualityManagement.Helper;
using QualityManagement.Repository;
using System;
using System.Threading;
using System.Threading.Tasks;

namespace QualityManagement.MediatR;
public class AddDocumentMetaTagCommandHandler(
    IDocumentMetaTagRepository _documentMetaTagRepository,
    IMapper _mapper,
    IUnitOfWork<QMSDbContext> _uow) : IRequestHandler<AddDocumentMetaTagCommand, ServiceResponse<DocumentMetaTagDto>>
{
    public async Task<ServiceResponse<DocumentMetaTagDto>> Handle(AddDocumentMetaTagCommand request, CancellationToken cancellationToken)
    {
        var entityExist = await _documentMetaTagRepository.FindBy(c => c.Name == request.Name).FirstOrDefaultAsync();
        if (entityExist != null)
        {
            return ServiceResponse<DocumentMetaTagDto>.Return409("DocumentMetaTag with same name already exists.");
        }
        var entity = _mapper.Map<DocumentMetaTag>(request);
        entity.Id = Guid.NewGuid();
        _documentMetaTagRepository.Add(entity);
        if (await _uow.SaveAsync() <= 0)
        {
            return ServiceResponse<DocumentMetaTagDto>.Return500();
        }
        var entityDto = _mapper.Map<DocumentMetaTagDto>(entity);
        return ServiceResponse<DocumentMetaTagDto>.ReturnResultWith201(entityDto);
    }
}