﻿using AutoMapper;
using MediatR;
using Microsoft.EntityFrameworkCore;
using QualityManagement.Data.Dto;
using QualityManagement.Repository;
using System.Collections.Generic;
using System.Linq;
using System.Threading;
using System.Threading.Tasks;

namespace QualityManagement.MediatR
{
    public class GetDocumentPermissionQueryHandler(
        IDocumentRolePermissionRepository _documentRolePermissionRepository,
         IDocumentUserPermissionRepository _documentUserPermissionRepository,
         IMapper _mapper) : IRequestHandler<GetDocumentPermissionQuery, List<DocumentPermissionDto>>
    {
        public async Task<List<DocumentPermissionDto>> Handle(GetDocumentPermissionQuery request, CancellationToken cancellationToken)
        {
            var result = new List<DocumentPermissionDto>();
            var documentRolePermissions = await _documentRolePermissionRepository
                .AllIncluding(c => c.Role)
                .Where(c => c.DocumentId == request.DocumentId)
                .ToListAsync();
            var rolePermissions = _mapper.Map<List<DocumentPermissionDto>>(documentRolePermissions);
            rolePermissions.ForEach(p => p.Type = "Role");
            result.AddRange(rolePermissions);

            var documentUserPermissions = await _documentUserPermissionRepository
                .AllIncluding(c => c.User)
                .Where(c => c.DocumentId == request.DocumentId)
                .ToListAsync();
            var userPermissions = _mapper.Map<List<DocumentPermissionDto>>(documentUserPermissions);
            userPermissions.ForEach(p => p.Type = "User");
            result.AddRange(userPermissions);
            return result;
        }
    }
}
