﻿using MediatR;
using Microsoft.EntityFrameworkCore;
using QualityManagement.Data.Dto;
using QualityManagement.Helper;
using QualityManagement.Repository;
using System.Threading;
using System.Threading.Tasks;

namespace QualityManagement.MediatR
{
    public class GetDocumenetByLinkIdQueryHandler(
        IDocumentShareableLinkRepository _documentShareableLinkRepository) : IRequestHandler<GetDocumenetByLinkIdQuery, ServiceResponse<DocumentShareableLinkDto>>
    {
        public async Task<ServiceResponse<DocumentShareableLinkDto>> Handle(GetDocumenetByLinkIdQuery request, CancellationToken cancellationToken)
        {
            var doc = await _documentShareableLinkRepository
                    .AllIncluding(c => c.Document)
                    .FirstOrDefaultAsync(cs => cs.Id == request.Id);
            if (doc == null)
            {
                return ServiceResponse<DocumentShareableLinkDto>.Return404();
            }

            var result = new DocumentShareableLinkDto
            {
                DocumentId = doc.DocumentId,
                DocumentName = doc.Document.Name,
                IsAllowDownload = doc.IsAllowDownload
            };
            return ServiceResponse<DocumentShareableLinkDto>.ReturnResultWith200(result);
        }
    }
}
