﻿using AutoMapper;
using MediatR;
using Microsoft.EntityFrameworkCore;
using QualityManagement.Data.Dto;
using QualityManagement.Helper;
using QualityManagement.Repository;
using System;
using System.Threading;
using System.Threading.Tasks;

namespace QualityManagement.MediatR
{
    public class GetLinkInfoByCodeQueryHanlder(
        IDocumentShareableLinkRepository _documentShareableLinkRepository,
        IMapper _mapper) : IRequestHandler<GetLinkInfoByCodeQuery, ServiceResponse<DocumentShareableLinkDto>>
    {
        public async Task<ServiceResponse<DocumentShareableLinkDto>> Handle(GetLinkInfoByCodeQuery request, CancellationToken cancellationToken)
        {
            var link = await _documentShareableLinkRepository.AllIncluding(c => c.Document)
                .FirstOrDefaultAsync(c => c.LinkCode == request.Code);
            if (link == null)
            {
                return ServiceResponse<DocumentShareableLinkDto>.Return404();
            }

            var linkInfo = _mapper.Map<DocumentShareableLinkDto>(link);
            linkInfo.DocumentName = link.Document?.Name;
            linkInfo.Url = link.Document?.Url;

            if (!string.IsNullOrWhiteSpace(link.Password))
            {
                linkInfo.HasPassword = true;
                var base64EncodedBytes = Convert.FromBase64String(linkInfo.Password);
                string existingPassowrd = System.Text.Encoding.UTF8.GetString(base64EncodedBytes);
                linkInfo.Password = existingPassowrd;
            }

            if (link.LinkExpiryTime.HasValue)
            {
                linkInfo.IsLinkExpired = DateTime.UtcNow > link.LinkExpiryTime;
            }

            return ServiceResponse<DocumentShareableLinkDto>.ReturnResultWith200(linkInfo);
        }
    }
}
