﻿using QualityManagement.Common.UnitOfWork;
using QualityManagement.Data.Entities;
using QualityManagement.Domain;
using QualityManagement.Repository;
using MediatR;
using System;
using System.Threading;
using System.Threading.Tasks;

namespace QualityManagement.MediatR
{
    public class AddDocumentTokenCommandHandler(IDocumentTokenRepository _documentTokenRepository, IUnitOfWork<QMSDbContext> _uow) : IRequestHandler<AddDocumentTokenCommand, string>
    {
        public async Task<string> Handle(AddDocumentTokenCommand request, CancellationToken cancellationToken)
        {
            var token = Guid.NewGuid();
            var documentToken = _documentTokenRepository.Find(request.DocumentId);
            if (documentToken == null)
            {
                _documentTokenRepository.Add(new DocumentToken
                {
                    CreatedDate = DateTime.UtcNow,
                    DocumentId = request.DocumentId,
                    Token = token
                });
                await _uow.SaveAsync();
            }
            else
            {
                token = documentToken.Token;
            }
            return token.ToString();
        }
    }
}
