﻿using QualityManagement.Data.Entities;
using QualityManagement.Repository;
using MediatR;
using Microsoft.EntityFrameworkCore;
using System.Linq;
using System.Threading;
using System.Threading.Tasks;

namespace QualityManagement.MediatR
{
    public class GetDocumentTokenCommandHandler(
        IDocumentTokenRepository _documentTokenRepository)
        : IRequestHandler<GetDocumentTokenCommand, DocumentToken>
    {
        public async Task<DocumentToken> Handle(GetDocumentTokenCommand request, CancellationToken cancellationToken)
        {
            var documentToken = await _documentTokenRepository.All.Where(c => c.Token == request.Token).FirstOrDefaultAsync();
            if (documentToken == null)
            {
                return null;
            }
            return documentToken;
        }
    }
}
