﻿using QualityManagement.Common.UnitOfWork;
using QualityManagement.Data.Entities;
using QualityManagement.Domain;
using QualityManagement.Repository;
using MediatR;
using Microsoft.EntityFrameworkCore;
using System;
using System.Linq;
using System.Threading;
using System.Threading.Tasks;

namespace QualityManagement.MediatR
{
    public class GetDocumentTokenQueryHandler(
        IDocumentTokenRepository _documentTokenRepository,
        IUnitOfWork<QMSDbContext> _uow,
        IDocumentVersionRepository _documentVersionRepository
        ) : IRequestHandler<GetDocumentTokenQuery, string>
    {
        public async Task<string> Handle(GetDocumentTokenQuery request, CancellationToken cancellationToken)
        {
            var token = Guid.NewGuid();
            var documentVersion = _documentVersionRepository.All.FirstOrDefault(c => c.DocumentId == request.Id && c.IsCurrentVersion || c.Id == request.Id);
            var documentToken = await _documentTokenRepository.All.FirstOrDefaultAsync(c => c.DocumentId == documentVersion.DocumentId);
            if (documentToken == null)
            {
                _documentTokenRepository.Add(new DocumentToken
                {
                    CreatedDate = DateTime.UtcNow,
                    DocumentId = request.Id,
                    Token = token
                });
                await _uow.SaveAsync();
            }
            else
            {
                token = documentToken.Token;
            }
            return token.ToString();
        }
    }
}
