﻿using MediatR;
using Microsoft.EntityFrameworkCore;
using QualityManagement.Data.Dto;
using QualityManagement.Repository;
using System.Collections.Generic;
using System.Linq;
using System.Threading;
using System.Threading.Tasks;

namespace QualityManagement.MediatR;

public class GetDocumentVersionCommandHandler(
    IDocumentRepository _documentRepository,
    IDocumentVersionRepository _documentVersionRepository) : IRequestHandler<GetDocumentVersionCommand, List<DocumentVersionDto>>
{
    public async Task<List<DocumentVersionDto>> Handle(GetDocumentVersionCommand request, CancellationToken cancellationToken)
    {
        var document = await _documentRepository.AllIncluding(c => c.User)
            .FirstOrDefaultAsync(c => c.Id == request.Id);

        if (document == null)
        {
            return new List<DocumentVersionDto>();
        }

        var documnetVersions = await _documentVersionRepository.AllIncluding(c => c.CreatedByUser, c => c.SignBy)
            .Where(c => c.DocumentId == request.Id)
            .OrderByDescending(c => c.VersionNumber)
            .Select(documnetVersion => new DocumentVersionDto
            {
                Id = documnetVersion.Id,
                Url = documnetVersion.Url,
                CreatedByUser = $"{documnetVersion.CreatedByUser.FirstName}  {documnetVersion.CreatedByUser.LastName}",
                ModifiedDate = documnetVersion.ModifiedDate,
                SignBy = documnetVersion.SignBy != null ? $"{documnetVersion.SignBy.FirstName}  {documnetVersion.SignBy.LastName}" : "",
                SignDate = documnetVersion.SignDate,
                Comment = documnetVersion.Comment,
                IsChunk = documnetVersion.IsChunk,
                DocumentId = documnetVersion.DocumentId,
                IsCurrentVersion = documnetVersion.IsCurrentVersion,
                VersionNumber = documnetVersion.VersionNumber,
                Extension = documnetVersion.Extension,
                IsSignatureExists = documnetVersion.SignBy != null
            }).ToListAsync();

        return documnetVersions;
    }
}