﻿using QualityManagement.Data.Dto;
using QualityManagement.Repository;
using MediatR;
using Microsoft.EntityFrameworkCore;
using System.Threading;
using System.Threading.Tasks;

namespace QualityManagement.MediatR
{
    public class DocumentSignByUserCommandHandler(IDocumentRepository documentRepository, UserInfoToken userInfoToken) : IRequestHandler<DocumentSignByUserCommand, bool>
    {
        public async Task<bool> Handle(DocumentSignByUserCommand request, CancellationToken cancellationToken)
        {
            return await documentRepository.All.AnyAsync(d => d.Id == request.DocumentId && d.SignById == userInfoToken.Id);
        }
    }
}
