﻿using MediatR;
using QualityManagement.Helper;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace QualityManagement.MediatR
{
    public class FileDownloadRequestCommand:IRequest<ServiceResponse<DocumentDownload>>
    {
        public Guid? StorageSettingId { get; set; }
        public byte[] Key { get; set; }
        public byte[] IV { get; set; }
        public List<FileChunk> Chunks { get; set; } = new List<FileChunk>();
        public string Extension { get; set; }
        public string FileName { get; set; }
    }
    public class FileChunk
    {
        public string Url { get; set; }
        public int ChunkIndex { get; set; }
    }
}
