﻿using QualityManagement.Repository;
using MediatR;
using System.Threading;
using System.Threading.Tasks;

namespace QualityManagement.MediatR;
public class GetAllArchiveDocumentQueryHandler(IDocumentRepository _documentRepository) : IRequestHandler<GetAllArchiveDocumentQuery, DocumentList>
{
    public async Task<DocumentList> Handle(GetAllArchiveDocumentQuery request, CancellationToken cancellationToken)
    {
        return await _documentRepository.GetArchiveDocuments(request.DocumentResource);
    }
}
