﻿using QualityManagement.Repository;
using MediatR;
using System.Threading;
using System.Threading.Tasks;

namespace QualityManagement.MediatR
{
    public class GetAllDocumentQueryHandler(IDocumentRepository _documentRepository) : IRequestHandler<GetAllDocumentQuery, DocumentList>
    {
        public async Task<DocumentList> Handle(GetAllDocumentQuery request, CancellationToken cancellationToken)
        {
            return await _documentRepository.GetDocuments(request.DocumentResource);
        }
    }
}
