﻿using QualityManagement.Data.Dto;
using QualityManagement.Helper;
using QualityManagement.Repository;
using MediatR;
using System.Threading;
using System.Threading.Tasks;

namespace QualityManagement.MediatR
{
    public class GetDocumentQueryHandler(IDocumentRepository _documentRepository, IUserNotificationRepository _userNotificationRepository) : IRequestHandler<GetDocumentQuery, ServiceResponse<DocumentDto>>
    {
        public async Task<ServiceResponse<DocumentDto>> Handle(GetDocumentQuery request, CancellationToken cancellationToken)
        {
            var entity = await _documentRepository.GetDocumentById(request.Id);
            // mark notification as read.
            await _userNotificationRepository.MarkAsReadByDocumentId(request.Id);
            if (entity != null)
                return ServiceResponse<DocumentDto>.ReturnResultWith200(entity);
            else
                return ServiceResponse<DocumentDto>.ReturnFailed(404, "Document is not found.");
        }
    }
}
