﻿using QualityManagement.Data.Dto;
using QualityManagement.Helper;
using MediatR;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using System;


namespace QualityManagement.MediatR
{
    public class UploadDocumentChunkCommand : IRequest<ServiceResponse<DocumentChunkDto>>
    {
        [FromForm]
        public IFormFile File { get; set; }
        public int ChunkIndex { get; set; }
        public long Size { get; set; }
        public int TotalChunks { get; set; }
        public string Extension { get; set; }
        public Guid DocumentVersionId { get; set; }

    }
}
