﻿using AutoMapper;
using QualityManagement.Data.Dto;
using QualityManagement.Helper;
using QualityManagement.Repository;
using MediatR;
using Microsoft.EntityFrameworkCore;
using System.Collections.Generic;
using System.Threading;
using System.Threading.Tasks;

namespace QualityManagement.MediatR
{
    public class GetAllEmailTemplateQueryHandler(
        IEmailTemplateRepository emailTemplateRepository,
        IMapper mapper
        ) : IRequestHandler<GetAllEmailTemplateQuery, ServiceResponse<List<EmailTemplateDto>>>
    {
        public async Task<ServiceResponse<List<EmailTemplateDto>>> Handle(GetAllEmailTemplateQuery request, CancellationToken cancellationToken)
        {
            var entities = await emailTemplateRepository.All.ToListAsync(cancellationToken);
            return ServiceResponse<List<EmailTemplateDto>>.ReturnResultWith200(mapper.Map<List<EmailTemplateDto>>(entities));
        }
    }
}
