﻿using AutoMapper;
using MediatR;
using Microsoft.EntityFrameworkCore;
using Microsoft.Extensions.Logging;
using QualityManagement.Common.UnitOfWork;
using QualityManagement.Data;
using QualityManagement.Data.Dto;
using QualityManagement.Domain;
using QualityManagement.Helper;
using QualityManagement.Repository;
using System.Linq;
using System.Threading;
using System.Threading.Tasks;

namespace QualityManagement.MediatR
{
    public class AddEmailSMTPSettingCommandHandler(
        IEmailSMTPSettingRepository _emailSMTPSettingRepository,
        IUnitOfWork<QMSDbContext> _uow,
        IMapper _mapper,
        ILogger<AddEmailSMTPSettingCommand> _logger) : IRequestHandler<AddEmailSMTPSettingCommand, ServiceResponse<EmailSMTPSettingDto>>
    {
        public async Task<ServiceResponse<EmailSMTPSettingDto>> Handle(AddEmailSMTPSettingCommand request, CancellationToken cancellationToken)
        {
            var entity = _mapper.Map<EmailSMTPSetting>(request);
            var defaultEmailSMTPSettings = await _emailSMTPSettingRepository.All.Where(c => c.IsDefault).ToListAsync();
            if (defaultEmailSMTPSettings.Count <= 0)
            {
                entity.IsDefault = true;
            }
            _emailSMTPSettingRepository.Add(entity);

            if (entity.IsDefault)
            {
                defaultEmailSMTPSettings.ForEach(c => c.IsDefault = false);
                _emailSMTPSettingRepository.UpdateRange(defaultEmailSMTPSettings);
            }

            if (await _uow.SaveAsync() <= -1)
            {
                _logger.LogError("Failed to save email SMTP settings.");
                return ServiceResponse<EmailSMTPSettingDto>.Return409("Failed to save email SMTP settings.");
            }

            var entityDto = _mapper.Map<EmailSMTPSettingDto>(entity);
            return ServiceResponse<EmailSMTPSettingDto>.ReturnResultWith200(entityDto);
        }
    }
}
